import React from 'react'
import {BrowserRouter as Router, Switch, Route, Redirect} from 'react-router-dom';

import BlankLayout from './layout/BlankLayout';
import CommonLayout from './layout/CommonLayout';
import Backlog from './pages/Backlog/Backlog'
import Work from './pages/Work/Work'
import Notice from './pages/Notice/Notice'
import Communicate from './pages/Communicate/Communicate'

import Process from './pages/EventProcessing/Process'

import NoFound from './pages/NoFound'


const ReactRouter = () => {
    return (
        <Router>
            <Switch>
                <Route exact path="/" render={() => <Redirect to="/bord/backlog" />} />
                <Route path="/bord" render={ () =>
                    <CommonLayout>
                        <Route path="/bord/backlog" component={Backlog}/>
                        <Route path="/bord/work" component={Work}/>
                        <Route path="/bord/communicate" component={Communicate}/>
                        <Route path="/bord/notice" component={Notice}/>
                    </CommonLayout>
                }/>
                <Route path="/blank" component={() =>
                    <BlankLayout>
                        <Route path="/blank/:name/:id" component={Process}/>
                    </BlankLayout>
                }/>
                <Route component={NoFound}/>
            </Switch>
        </Router>
    );
};



export default ReactRouter;

