import React, {Component} from 'react';
import './index.less'
import CardItem from './CardItem'

class Index extends Component {
    render() {
        const {title, type, addStatus, addCommon, data, iconAction} = this.props;
        const emptyIcon = type === 'edit' ? {
            text: addStatus ? '完成添加' :'添加常用', icon: addStatus ? '/img/finish-work.png' : '/img/add-work.png', iconAdd: true
        } : {};

        const empty = data.length % 3;
        empty === 0 && data.push(emptyIcon, {}, {});
        empty === 1 && data.push(emptyIcon, {});
        empty === 2 && data.push(emptyIcon);

        return (
            <div>
                <div className="work-card-title">
                    {title}
                </div>
                <div className="work-card-body">
                    {data.map((item, index) => (
                        <CardItem
                            type={type}
                            key={index}
                            data={item}
                            addStatus={addStatus}
                            addCommon={addCommon}
                            iconAction={iconAction}
                        />
                    ))}

                </div>
            </div>
        );
    }
}

export default Index;


