import React from 'react';
import './index.less'

const Index = (props) => {
    return (
        <div className="auto-list-card">
            {props.title && (
                <div className="auto-list-item auto-list-item-title">{props.title}</div>
            )}
            {props.listData.map((item, index) => (
                <div key={index} className={`auto-list-item ${item.line ? 'auto-list-item-line-feed' : 'auto-list-item-line'}`}>
                    <div className="auto-list-title">
                        {item.title}：
                    </div>
                    <div className="auto-list-content">
                        {item.content}
                    </div>
                </div>
            ))}

        </div>
    );
};

export default Index;
