import React, { useState, useEffect } from 'react';
import {ActivityIndicator, WhiteSpace, WingBlank} from "antd-mobile";
import axiosRequest, { loading } from '../../utils/request';
import TopSearch from '../../components/TopSearch'
import WorkCard from '../../components/WorkCard'

const Work = () => {

    const [addStatus, setAddStatus] = useState(false);
    const [operates, setOperates] = useState([]);

    useEffect(() => {
        loadOperates();
    }, []);

    const loadOperates = () => {
        axiosRequest({
            method: 'post',
            url: '/dgbg/mobileGetOperates.view?userName=2012012099&clientFlag=123456',
        }).then(res => {
            setOperates(res.operate || []);
        });
    }

    const commonEdit = () => {
        setAddStatus(!addStatus);
    };

    const workSearch = (val) => {
        console.log(val)
    };

    const itemAdd = (id, arr, arr2) => {
        // const item = arr2.filter(item => item.id === id);
        // arr.splice(arr.length - 1, 0, item[0]);
    };

    const itemSlice = (id, arr, arr2) => {
        // const index = arr.findIndex(item => item.id == id);
        // index > -1 && arr.splice(index, 1);
    };
    return (
        <WingBlank>
            <ActivityIndicator
                toast
                text="加载中..."
                animating={loading}
            />
            <WhiteSpace/>
            <TopSearch onSearch={ workSearch }/>
            <WhiteSpace/>
            <WorkCard
                title="事物管理"
                addCommon={ commonEdit }
                addStatus={addStatus}
                data={ operates.map(item => ({ icon: '', text: item.NODENAME }))}
                iconAction={ itemAdd }
            />
        </WingBlank>
    );
}


export default Work;

