import React, {useState, useEffect} from 'react';
import {WingBlank, WhiteSpace, ActionSheet, ActivityIndicator} from 'antd-mobile'
import './index.less'
import TopTabs from '../../components/BlankTabs'
import Basic from './Basic'
import Adjunct from './Adjunct'
import Flow from './Flow';
import Option from './Option';

const Pro = (props) => {
    const [loading, setLoading] = useState(false);

    //提交按钮状态
    const [disabled, setDisabled] = useState(true)
    //提交按钮文字
    const [footButton, setFootButton] = useState('确认发送');
    //聚焦
    const optionBlur = () => {
        setFootButton('确认发送');
        setFootStatus(true)
    };
    useEffect(() => {
        const option = document.getElementsByClassName("option-text")[0]
        option.addEventListener('focus', optionBlur, true);
        return () => option.removeEventListener('focus', optionBlur, true);
    }, []);

    const optionChange = val => {
        setDisabled(!(val != null && val != undefined && val != ''))
    };

    const [current, setCurrent] = useState('basic');

    const [footStatus, setFootStatus] = useState(false);

    //点击输入框， 聚焦移动
    const textClick = () => {
        const top = document.getElementById(`event-option`).offsetTop;
        document.getElementById("event").scrollTo(0,top)
        document.getElementsByClassName("option-text")[0].focus();
        optionBlur()
    };

    //tab切换
    const tabClick = (name) => {
        setCurrent(name)
        name === 'option' && document.getElementsByClassName("option-text")[0].focus();
        name === 'option' && optionBlur()
        const top = document.getElementById(`event-${name}`).offsetTop;
        document.getElementById("event").scrollTo(0,top);
    };


    //antd-mobile 提交选项
    const isIPhone = new RegExp('\\biPhone\\b|\\biPod\\b', 'i').test(window.navigator.userAgent);
    let wrapProps;
    if (isIPhone) {
        wrapProps = {
            onTouchStart: e => e.preventDefault(),
        };
    }
    const showActionSheet = () => {
        const BUTTONS = ['送部门领导审核', '送办公室分管主任审批', '办结', '取消'];
        ActionSheet.showActionSheetWithOptions({
                options: BUTTONS,
                cancelButtonIndex: BUTTONS.length - 1,
                maskClosable: true,
                wrapProps,
            },
            (buttonIndex) => {
                props.history.push(`/blank/submit/1`)
                // console.log(buttonIndex)
            });
    };

    const handleScroll = () => {
        const adjunct = document.getElementById("event-adjunct").offsetTop;
        const flow = document.getElementById("event-flow").offsetTop;
        const option = document.getElementById("event-option").offsetTop;
        const event = document.getElementById('event');
        const top = event.scrollTop;
        const scrollHeight = event.scrollHeight;
        const clientHeight = event.clientHeight
        if (top >= 0 && top < adjunct) {
            setCurrent('basic')
        }else if (top >= adjunct && top < flow) {
            setCurrent('adjunct')
        }else if (top >= flow && top < option) {
            setCurrent('flow')
        }else if (top >= option) {
            setCurrent('option')
        }
        if (top + clientHeight === scrollHeight) {
            setCurrent('option')
        }
    };
    useEffect(() => {
        window.addEventListener('scroll', handleScroll, true);
        return () =>  window.removeEventListener('scroll', handleScroll, true);
    }, [])
    return (
        <div>
            <ActivityIndicator
                toast
                text="加载中..."
                animating={loading}
            />
            <TopTabs page={current} onClick={tabClick}/>
            <div id="event">
                <WingBlank>
                    <div id="event-basic"/>
                    <WhiteSpace/>
                    <Basic/>
                    <div id="event-adjunct"/>
                    <WhiteSpace/>
                    <Adjunct/>
                    <div id="event-flow"/>
                    <WhiteSpace/>
                    <Flow/>
                    <div id="event-option"/>
                    <WhiteSpace/>
                    <Option onChange={optionChange}/>
                </WingBlank>
            </div>
            <div className="event-footer">
                <div className={`event-footer-button ${(footStatus && disabled) ? 'button-disabled' : '' }`} onClick={footStatus && !disabled ? showActionSheet: textClick}>
                    {!footStatus && (
                        <img alt="" src="/img/process-edit.png" className="process-edit"/>
                    )}
                    {footButton}
                </div>

            </div>

        </div>
    );
};

export default Pro;
