import React, {useState, useEffect} from 'react';
import {WhiteSpace, WingBlank, ActivityIndicator} from 'antd-mobile'
import TodoCard from '../../components/LogCard'
import TopSearch from '../../components/TopSearch'

const Backlog = (props) => {
    const [current, setCurrent] = useState(1);
    const [searchWord, setSearchWord] = useState()

    const [loading, setLoading] = useState(false);

    const [data, setData] = useState([{},{},{},{},{},{}]);

    const checkLog = () => {
        props.history.push(`/blank/info/example/1`)
    };
    const getData = () => {
        setLoading(false)
        const pageMap ={searchWord, nowPage: current, pageSize: 10}
        let result = data.concat([{}, {}, {}, {}, {}, {}])
        setData(result)
        setCurrent(current + 1)
    };

    //下拉加载
    const handleScroll = () => {
        const event = document.getElementById("common-content")
        const top = event.scrollTop;
        const scrollHeight = event.scrollHeight;
        const clientHeight = event.clientHeight;
        if (top + clientHeight === scrollHeight) {
            setLoading(true);
            getData()
        }
    };
    useEffect(() => {
        window.addEventListener('scroll', handleScroll, true);
        return () =>  window.removeEventListener('scroll', handleScroll, true);
    }, [data]);

    useEffect(() => {
        const element = document.getElementById('common-content')
        element.scrollTo(0, 0)
    }, [])

    return (
        <WingBlank>
            <ActivityIndicator
                toast
                text="加载中..."
                animating={loading}
            />
            <WhiteSpace/>
            <TopSearch onSearch={setSearchWord}/>
            {
                data.map((item, index) => (
                    <div key={index}>
                        <WhiteSpace/>
                        <TodoCard data={item} onClick={checkLog}/>
                    </div>

                ))
            }

        </WingBlank>
    );
};

export default Backlog;
