import React, {Component} from 'react';
import {TabBar} from 'antd-mobile'
import './index.less'

class Footer extends Component {
    state={
        current: ''
    }
    componentDidMount() {
        const keysArray = this.props.location.pathname.replace(`${this.props.match.path}/`, '').split("/");
        keysArray.length > 0 && this.setState({current: keysArray[0]})
    }
    tabClick = (key, path) => {
       this.setState({current: key})
        this.props.history.push(path)
    }


    render() {
        const tabItem = [
            {title: '待办', key: 'backlog', icon: '/img/footer-backlog.png', selectedIcon: '/img/footer-backlog-s.png', badge: '', onPress: '/bord/backlog'},
            {title: '工作', key: 'work', icon: '/img/footer-work.png', selectedIcon: '/img/footer-work-s.png', badge: '', onPress: '/bord/work'},
            {title: '通讯录', key: 'addressList', icon: '/img/footer-communicate.png', selectedIcon: '/img/footer-communicate-s.png', badge: '', onPress: '/bord/addressList'},
            {title: '通知', key: 'notice', icon: '/img/footer-notice.png', selectedIcon: '/img/footer-notice-s.png', badge: '', onPress: '/bord/notice'}
        ];

        return (
            <div id="footer" className="footer">
                <TabBar
                    unselectedTintColor="#949494"
                    tintColor="#2E67EA"
                    barTintColor="white"
                >
                    {tabItem.map(item => (
                        <TabBar.Item
                            key={item.key}
                            title={item.title}
                            icon={<img alt="" className="footer-tab-icon" src={item.icon}/>}
                            selectedIcon={ <img alt="" className="footer-tab-icon" src={item.selectedIcon}/>}
                            badge={item.badge || null}
                            onPress={() => this.tabClick(item.key, item.onPress)}
                            selected={this.state.current === item.key}
                        />
                    ))}
                </TabBar>
            </div>
        );
    }
}

export default Footer;



