import React, {useEffect, useState} from 'react';
import Footer from './Footer'
import {withRouter} from 'react-router-dom'
import './index.less'


const CommonLayout = (props) => {
    const resize = (defaultH) => {
        const scrollHeight = document.body.scrollHeight;
        const footer = document.getElementById("footer");
        const content = document.getElementById("common-content")
        if (footer) {
            if (defaultH > scrollHeight) {
                footer.classList.remove('footer');
                footer.classList.add('footer-static')
            }else {
                footer.classList.add('footer')
                footer.classList.remove('footer-static');

            }
        }
        if (content) {
            if (defaultH > scrollHeight) {
                content.classList.remove('common-layout-content');
                content.classList.add('common-layout-content-static');
            }else {
                content.classList.add('common-layout-content');
                content.classList.remove('common-layout-content-static');
            }
        }

        // alert(`defaultH: ${defaultH}   clientHeight: ${scrollHeight}`);
    };

    useEffect(() => {
        const defaultH = document.body.scrollHeight;
        window.addEventListener('resize', () => resize(defaultH));
        return () =>  window.removeEventListener('resize', resize);
    }, [])
    return (
        <div>
            <div id="common-content" className="common-layout-content">
                <div>
                    {props.children}
                </div>

            </div>
            <Footer {...props}/>
        </div>
    );
};

export default withRouter(CommonLayout) ;
