import React from 'react';
import './index.less'

const Index = (props) => {
    return (
        <div className="todo-card" onClick={props.onClick}>
            <div className="todo-title pos-aline">
                <div className="pos-aline">
                    <div className="todo-tag pos-aline">
                        <img
                            alt=""
                            className="todo-tag-png"
                            src="https://timgsa.baidu.com/timg?image&quality=80&size=b9999_10000&sec=1591252471425&di=85236ae603ca74553adaca6e8c161a39&imgtype=0&src=http%3A%2F%2Fhbimg.b0.upaiyun.com%2Fb912bf96dc19b3b23530ae2259b60eb6cf70083f6680b-H9l0ri_fw658"
                        />
                        {props.TYPE}
                    </div>
                    <p>{props.TITLE}</p>
                </div>
                <span>
                    <img
                        alt=""
                        className="todo-read-png"
                        src={props.data && props.data.read ? '/img/read.png' : '/img/unread.png'}
                    />
                </span>
            </div>
            <div className="todo-content">
                <p>当前状态：{props.STATUS}</p>
                <p style={{marginTop: 15}}>发送人员：{props.FROMUSER_ALIASED}</p>
            </div>
            <div className="todo-footer">
               <div>
                   <p className="pos-aline"><img alt="" src="/img/time.png" className="footer-mes-img"/>更新时间：2020-05-26  17:51</p>
                   <p className="pos-aline footer-mes-sec"><img alt="" src="/img/time-2.png" className="footer-mes-img"/>停滞时间：24h</p>
               </div>
                <img
                    alt=""
                    className="todo-footer-img"
                    src={props.data && props.data.read ? '/img/serious.png' : '/img/urgency.png'}
                />
            </div>
        </div>
    );
};

export default Index;
