import axios from 'axios';
const instance = axios.create();

export const apiUrl = '/';

const token = localStorage.getItem("token");

let defaultHeaders = {
    token,
};
const createAPI = (baseURL) => {
    return (conf = {}) => {
        let opts = conf.opts || {};

        let headers = { ...defaultHeaders, ...opts.headers };

        return instance(Object.assign({}, {
            url: conf.url,
            baseURL: baseURL,
            params: conf.opts,
            method: conf.method,
            data: conf.payload || null,
            headers,
            responseType: 'blob',
        }))
            .then(function (response) {
                return response
            })
            .catch(error => {
                return false;
            });
    };
}

const instance2 = createAPI(apiUrl);

async function downloadFile(option = {}) {
    return  await instance2({
        method: option.method || 'get',
        url: option.url,
        opts: option.body || null,
    });
}


export default downloadFile;


