import React from 'react'
import {BrowserRouter as Router, Switch, Route, Redirect} from 'react-router-dom';

import BlankLayout from './layout/BlankLayout';
import CommonLayout from './layout/CommonLayout';
import Backlog from './pages/Backlog/Backlog'
import Work from './pages/Work/Work'
import WorkDetail from './pages/Work/WorkDetail'
import WorkAdd from './pages/Work/AddWork'
import Notice from './pages/Notice/Notice'
import AddressBook from './pages/Communicate/AddressBook';
import NewAddress from './pages/Communicate/NewAddress';
import NewPage from './pages/Communicate/NewPage';
import Process from './pages/EventProcessing/Process'
import SubmitDetail from './pages/EventProcessing/SubmitDetail'
import Date from './pages/UnCommon/Date'
import Mail from './pages/UnCommon/Mail'
import Application from './pages/EventProcessing/UnCommon/Application'
import MainInfo from './pages/UnCommon/Mail/Info'
import MainSend from './pages/UnCommon/Mail/Send'
import People from './pages/EventProcessing/UnCommon/People'
import Login from './pages/Login'
import MeetInfo from './pages/Work/components/MeetInfo'
import NoFound from './pages/NoFound'
import User from './pages/User/User'

import Send from './pages/Test/Send'
import Receive from './pages/Test/Receive'

const ReactRouter = () => {
    return (
        <Router>
            <Switch>
                <Route exact path="/" render={() => <Redirect to="/login" />} />
                <Route path="/login" component={Login} />
                <Route path="/bord" render={ () =>
                    <CommonLayout>
                        <Route path="/bord/backlog" component={Backlog}/>
                        <Route path="/bord/work" component={Work}/>
                        <Route path="/bord/addressList" component={NewAddress}/>
                        <Route path="/bord/address/:pId/:HASUSER/:parent" component={NewPage}/>

                        <Route path="/bord/notice" component={Notice}/>
                    </CommonLayout>
                }/>
                <Route path="/blank" component={() =>
                    <BlankLayout>
                        <Route path="/blank/addressList" component={AddressBook}/>
                        <Route path="/blank/date" component={Date}/>
                        <Route path="/blank/mail" component={Mail}/>
                        <Route path="/blank/mail-info/:uuid" component={MainInfo}/>
                        <Route path="/blank/mail-send" component={MainSend}/>
                        <Route path="/blank/people/:attachId" component={People}/>
                        <Route path="/blank/application/:id/:uuid/:FLOWTBID" component={Application}/>

                        <Route path="/blank/meet/add-room" component={MeetInfo}/>
                        <Route path="/blank/work/:type/:name" component={WorkDetail}/>
                        <Route path="/blank/work-add/:name" component={WorkAdd}/>
                        <Route path="/blank/submit/:flowNodeId/:uuid/:flowTbId" component={SubmitDetail}/>
                        <Route path="/blank/info/:id/:uuid/:FLOWTBID" component={Process}/>
                        <Route path="/blank/user" component={User}/>

                        <Route path="/blank/test/send" component={Send}/>
                        <Route path="/blank/test/receive/:id" component={Receive}/>
                    </BlankLayout>
                }/>
                <Route component={NoFound}/>
            </Switch>
        </Router>
    );
};



export default ReactRouter;

