import React, {useState, useEffect} from 'react';
import {List, Modal, WhiteSpace, WingBlank} from "antd-mobile";
import './index.less'
import axiosRequest from "../../../utils/request";
const alert = Modal.alert;

const Send = (props) => {
    const {visible, onClose, selectR} = props

    const selectRoom = (HYSDD) => {
        onClose(false);
        alert('会议室选择', '确定选中此会议室吗', [
            { text: '取消', onPress: () => onClose(true)},
            { text: '确认',
                onPress: () =>{
                    selectR(HYSDD)
                }
            },
        ])
    };
    const [data, setData] = useState([]);
    useEffect(() => {
        const developer = localStorage.getItem('developer');
        axiosRequest({
            method: 'post',
            url: '/idtAppServiceV6/control/getGrid',
            body: {
                script: 'getMeetRoom',
                replaceMap: JSON.stringify({developer}),
                args: JSON.stringify([]),
                keys: JSON.stringify([])
            },
        }).then((res) => {
            setData(res.DataList)
        })
    }, []);

    return (
        <div>
            <Modal
                title="选择会议室"
                className="date-modal"
                visible={visible}
                transparent
                onClose={() => onClose(false)}
            >
                <WingBlank className="meet-room">
                    <List>
                        {data && data.length > 0 && data.map((item, index) => (
                            <List.Item className="room-flex" key={index} onClick={() => selectRoom(item.HYSDD)} extra={
                                <div>{item.ZT}</div>
                            }> {item.HYSM} （{item.HYSDD}）</List.Item>
                        ))}
                    </List>

                    <WhiteSpace/>
                </WingBlank>
            </Modal>
        </div>
    );
};

export default Send;
