import React from 'react';
import { createForm } from 'rc-form';
import {List, Picker, InputItem, Button, Modal, DatePicker} from "antd-mobile";
import './index.less'

const Send = (props) => {
    const {visible, onClose, addGoods, columns} = props;
    const {getFieldProps, resetFields} = props.form;
    const handleClose = () => {
        resetFields();
        onClose()
    };
    const handleSubmit = () => {
        props.form.validateFields({ force: true }, (error) => {
            if (!error) {
                const values = props.form.getFieldsValue();
                addGoods(values);
                handleClose()
            }
        });

    };

    const getMode = val => {
        const date = /^(\w{4})-(\w{2})-(\w{2})$/;
        const time = /^(\w{2}):(\w{2}):(\w{2})$/;
        return date.test(val) ? 'date' : (time.test(val) ? 'time' : 'datetime')
    };

    return (
        <div>
            <Modal
                title="添加物品"
                className="date-modal"
                visible={visible}
                transparent
                onClose={handleClose}
            >
                <form>
                    <List className="goods-form">
                        {columns && columns.length > 0 && columns.map((item, index) => {
                            if (item.type === 'DATE') {
                                return (
                                    <DatePicker key={index} mode={getMode(item.dateType)} className="send-date-style"{...getFieldProps(item.label)}>
                                        <List.Item arrow="horizontal">{item.label}</List.Item>
                                    </DatePicker>
                                )
                            }else if (item.data) {
                                return (
                                    <Picker key={index} data={item.data} cols={1} {...getFieldProps(item.label)}>
                                        <List.Item arrow="horizontal">{item.label}</List.Item>
                                    </Picker>
                                )
                            } else {
                                return <InputItem key={index}{...getFieldProps(item.label)}>{item.label}</InputItem>
                            }
                        })}
                    </List>
                </form>

                <div className="modal-form-footer">
                    <Button className="gray-button" inline onClick={handleClose}>关闭</Button>
                    <Button className="date-button" inline type="primary" onClick={handleSubmit}>保存</Button>
                </div>
            </Modal>
        </div>
    );
};

export default createForm()(Send);
