import React, {useState} from 'react';
import {WingBlank, List, InputItem, ImagePicker, WhiteSpace, Toast, DatePicker, Picker} from 'antd-mobile'
import Document from 'react-document-title';
import './index.less';
import moment from 'moment'
import fileRequest from '../../utils/fileRequest';

import { createForm } from 'rc-form';


const Send = (props) => {
    const {getFieldProps} = props.form;

    const uploadPng = () => {
        const formData = new FormData();
        upload.length > 0 && formData.append('file', upload[0].file);
        fileRequest({
            method: 'post',
            url: '/idtAppServiceV6/oApp/uploadPhoto',
            payload: formData
        }).then(res => {

        });
    };


    const onSubmit = () => {
        props.form.validateFields({ force: true }, (error) => {
            const values = props.form.getFieldsValue();

            values.gzrq = moment(values.gzrq).format("YYYY-MM-DD");
            values.csrq = moment(values.csrq).format("YYYY-MM-DD");
            if (!error) {
                uploadPng();
                fileRequest({
                    method: 'post',
                    url: '/idtAppServiceV6/oApp/changeUserInfo',
                    body: {...values},
                }).then(res => {
                    Toast.success('发送成功');
                    props.history.push('/blank/mail');
                });
            }else {
                Toast.fail('请输入完整的主题、收件人、内容')
            }
        });
    };

    const [upload, setUpload] = useState([]);

    const uploadChange = (files, type, index) => {
        // console.log(files, type, index)
        setUpload(files)
    }

    const userInfo = JSON.parse(localStorage.getItem('userInfo'));

    return (
        <Document title="内部邮局">
            <WingBlank>
                <WhiteSpace/>
                <form>
                    <List>
                        <div className="user-img">
                            头像设置
                            <ImagePicker
                                length={1}
                                files={upload}
                                onChange={uploadChange}
                                selectable={upload.length < 1}
                            />
                        </div>

                        {/*<WingBlank>*/}
                            {/*{upload.length > 0 && upload.map((item, index) => (*/}
                                {/*<div>1111</div>*/}
                            {/*))}*/}
                        {/*</WingBlank>*/}
                        {/*<Upload className="auto-upload" {...uploaderProps}>*/}
                            {/*<a className="auto-upload">上传附件 +</a>*/}
                        {/*</Upload>*/}

                        <InputItem disabled={true} value={userInfo.userealname}>姓名</InputItem>
                        <InputItem disabled={true} value={userInfo.useName}>账号</InputItem>
                        <Picker data={[{label: '男', value: '男'}, {label: '女', value: '女'}]} cols={1} {...getFieldProps('xb', {initialValue: userInfo.xb})}>
                            <List.Item arrow="horizontal">性别</List.Item>
                        </Picker>
                        <DatePicker mode="date" className="send-date-style"{...getFieldProps('gzrq', {initialValue: new Date(userInfo.gzrq)})}>
                            <List.Item arrow="horizontal">工作日期</List.Item>
                        </DatePicker>
                        <DatePicker mode="date" className="send-date-style"{...getFieldProps('csrq', {initialValue: new Date(userInfo.csrq)})} onChange={val => console.log(val)}>
                            <List.Item arrow="horizontal">出生日期</List.Item>
                        </DatePicker>
                        <InputItem{...getFieldProps('gzdh', {initialValue: userInfo.gzdh})}>工作电话</InputItem>
                        <InputItem{...getFieldProps('yddh', {initialValue: userInfo.yddh})}>手机号码</InputItem>
                        <InputItem{...getFieldProps('sjxh', {initialValue: userInfo.sjxh})}>手机小号</InputItem>
                        <InputItem{...getFieldProps('email', {initialValue: userInfo.email})}>邮箱地址</InputItem>
                    </List>
                </form>
                <div className="event-footer">
                    <div className="event-footer-button" onClick={onSubmit}>保存</div>
                </div>
            </WingBlank>
        </Document>
    );
};

export default createForm()(Send);
