import React, {useState} from 'react';
import {WingBlank, List, InputItem, TextareaItem, WhiteSpace, Toast} from 'antd-mobile'
import Document from 'react-document-title';
import '../index.less';
import fileRequest from '../../../utils/fileRequest';
import Upload from 'rc-upload';
import MailA from '../../../components/Adjunct/MailA'

import { createForm } from 'rc-form';


const Send = (props) => {
    const {getFieldProps} = props.form;

    const [loading, setLoading] = useState(false);
    console.log(loading)

    const onSubmit = () => {
        props.form.validateFields({ force: true }, (error) => {
            const values = props.form.getFieldsValue();
            const jsonParam = {...values,  _mail_option: 'send', _mail_has_blob: upload.length > 0};
            setLoading(true);
            const formData = new FormData();
            upload.length > 0 && upload.forEach(file => {
                formData.append('blob', file);
            });
            if (!error) {
                fileRequest({
                    method: 'post',
                    url: '/idtAppServiceV6/jspmail/sendMail',
                    body: {jsonParam: JSON.stringify(jsonParam)},
                    payload: formData
                }).then(res => {
                    Toast.success('发送成功');
                    props.history.push('/blank/mail');
                    setLoading(true)
                });
            }else {
                Toast.fail('请输入完整的主题、收件人、内容')
            }
        });
    };
    const [upload, setUpload] = useState([]);

    const uploaderProps = {
        multiple: true,
        beforeUpload(file) {
            const newUpload = [...upload, file];
            setUpload(newUpload);
            return false
        }
    };
    const uploadDelete = uid => {
        const newData = [...upload];
        const Index = newData.findIndex(item => item.uid === uid);
        Index > -1 && newData.splice(Index, 1);
        setUpload(newData)
    }
    return (
        <Document title="内部邮局">
            <WingBlank>
                <WhiteSpace/>
                <form>
                    <List>
                        <InputItem
                            {...getFieldProps('_mail_title_text',  {rules: [{ required: true, message: '请输入主题'}]})}
                            placeholder="请输入主题"
                        >主题</InputItem>
                        <InputItem
                            {...getFieldProps('_mail_sjr_text', {rules: [{ required: true, message: '请输入收件人'}]})}
                            placeholder="请输入收件人"
                        >收件人</InputItem>
                        <TextareaItem
                            title="内容"
                            placeholder="请输内容"
                            {...getFieldProps('_mail_editor_text', {rules: [{ required: true, message: '请输内容'}]})}
                            rows={4}
                        />
                        <div className="am-textarea-label upload-title">附件：</div>
                        <WingBlank>
                            {upload.length > 0 && upload.map((item, index) => (
                                <MailA key={index} data={item} onDelete={uploadDelete}/>
                            ))}
                        </WingBlank>
                        <Upload className="auto-upload" {...uploaderProps}>
                            <a className="auto-upload">上传附件 +</a>
                        </Upload>
                        <WhiteSpace/>
                    </List>
                </form>
                <div className="event-footer">
                    <div className="event-footer-button" onClick={onSubmit}>发送</div>
                </div>
            </WingBlank>
        </Document>
    );
};

export default createForm()(Send);
