import React, {useState} from 'react';
import {WingBlank, List, InputItem, WhiteSpace, DatePicker, Toast, ActivityIndicator} from 'antd-mobile'
import Document from 'react-document-title';
import moment from 'moment'
import axios from  'axios'
import './index.less'

import { createForm } from 'rc-form';
import PeopleInfo from "./PeopleInfo";

const Send = (props) => {
    const {getFieldProps} = props.form;


    const onSubmit = () => {
        props.form.validateFields({ force: true }, (error) => {
            if (!error) {
                const values = props.form.getFieldsValue();
                const keys = Object.keys(values);
                keys.map(item => {
                    !values[item] && (delete values[item]);
                    Array.isArray(values[item]) && values[item].length === 1 && (values[item] = values[item][0]);
                    values[item] instanceof Date && ( values[item] = moment(values[item]).valueOf());
                    return null;
                });
                setLoading(true);
                values.toUid = sP.value;
                values.uid = sPU.value;
                axios.patch('/demo/initiateApproval', values).then(res => {
                    setLoading(false);
                    res.data.success && Toast.success('提交成功')
                })
            }
        });
    };

    const [sP, setSP] = useState({});
    const [sPU, setSPU] = useState({})
    const [sType, setSType] = useState();
    const [personVisible, setPersonVisible] = useState(false);
    const [loading, setLoading] = useState(false);

    const peopleSelect = (type) => {
        setSType(type);
        setPersonVisible(true)
    }

    return (
        <Document title="请假申请">
            <WingBlank>
                <PeopleInfo
                    text={sType === 'toUid' ? '选择审核人员' : '选择发送人'}
                    visible={personVisible}
                    onClose={setPersonVisible}
                    peopleData={sType === 'toUid' ? sP : sPU}
                    onSelect={sType === 'toUid' ? setSP : setSPU}
                />
                <WhiteSpace/>
                <form>
                    <List>
                        <InputItem {...getFieldProps('title')}>标题</InputItem>
                        {/*<InputItem value={'cgcPcPoo'}>发送人</InputItem>*/}
                        <List.Item className="auto-flex" extra={
                            <div className="pos-aline">
                                <div className="meet-select-btn" onClick={() => peopleSelect('uid')}>选择发送人</div>
                                <div>{sPU.name}</div>
                            </div>
                        }>发送人</List.Item>
                        <DatePicker mode="date" className="send-date-style"{...getFieldProps('startTime')}>
                            <List.Item arrow="horizontal">请假开始时间</List.Item>
                        </DatePicker>
                        <DatePicker mode="date" className="send-date-style"{...getFieldProps('entTime')}>
                            <List.Item arrow="horizontal">请假结束时间</List.Item>
                        </DatePicker>
                        <List.Item className="auto-flex" extra={
                            <div className="pos-aline">
                                <div className="meet-select-btn" onClick={() => peopleSelect('toUid')}>选择审核人员</div>
                                <div>{sP.name}</div>
                            </div>
                        }>审核人员</List.Item>
                        {/*<InputItem {...getFieldProps('gzdh')}>工作电话</InputItem>*/}
                    </List>
                </form>
                <div className="event-footer">
                    <div className="event-footer-button" onClick={onSubmit}>提交</div>
                </div>
                {loading && (
                    <ActivityIndicator
                        toast
                        text="提交中..."
                        animating={loading}
                    />
                )}
            </WingBlank>
        </Document>
    );
};

export default createForm()(Send);
