import React, {useEffect, useState} from 'react';
import {WingBlank, List, InputItem, WhiteSpace, Picker, Toast, ActivityIndicator} from 'antd-mobile'
import Document from 'react-document-title';
import moment from 'moment'
import axios from  'axios'

import { createForm } from 'rc-form';

const Receive = (props) => {
    const {id} = props.match.params;
    const {getFieldProps} = props.form;
    const [defaultV, setDefaultV] = useState({});
    const [loading, setLoading] = useState(false);
    const getListItem  = () => {
        axios({
            method: 'get',
            url: `/demo/leaveForm/${id}`,
            data: {},
            withCredentials: false,
        }).then(res => {
            res.data.data.result && setDefaultV(res.data.data.result)
        })
    };
    useEffect(() => {
        getListItem()
    }, []);

    const onSubmit = () => {
        props.form.validateFields({ force: true }, (error) => {
            const values = props.form.getFieldsValue();
            if (!error) {
                setLoading(true);
                axios({
                    method: 'patch',
                    url: `/demo/reviewAndApproval`,
                    params: {status: values.status[0], id},
                    withCredentials: false,
                }).then(res => {
                    setLoading(false);
                    res.data.data.result && Toast.success('审核成功', 1, () => {
                        getListItem()
                    })
                })
            }
        });
    };

    return (
        <Document title="请假审批">
            <WingBlank>
                <WhiteSpace/>
                <form>
                    <List>
                        <InputItem disabled={true} extra={defaultV.title && defaultV.title}>标题</InputItem>
                        <InputItem disabled={true} extra={defaultV.displayName}>请假人</InputItem>
                        <InputItem disabled={true} extra={defaultV.startTime && moment(defaultV.startTime).format("YYYY-MM-DD HH:mm:ss")}>请假开始时间</InputItem>
                        <InputItem disabled={true} extra={defaultV.entTime && moment(defaultV.entTime).format("YYYY-MM-DD HH:mm:ss")}>请假结束时间</InputItem>
                        {defaultV.status > 1 ?  <InputItem disabled={true} extra={['审核中', '审核成功', '审核失败'][defaultV.status - 1]}>办理意见</InputItem> : (
                            <Picker data={[{label: '审核通过', value: 2}, {label: '审核失败', value: 3}]} cols={1} {...getFieldProps('status')}>
                                <List.Item arrow="horizontal">办理意见</List.Item>
                            </Picker>
                        )}
                    </List>
                </form>
                {defaultV.status === 1 && (
                    <div className="event-footer">
                        <div className="event-footer-button" onClick={onSubmit}>提交</div>
                    </div>
                )}
                {loading && (
                    <ActivityIndicator
                        toast
                        text="提交中..."
                        animating={loading}
                    />
                )}

            </WingBlank>
        </Document>
    );
};

export default createForm()(Receive);
