import React, { useEffect, useState } from 'react';
import {Modal, Accordion, List, Radio, Button} from "antd-mobile";
import './index.less'
import axios from "axios";

const RadioItem  = Radio.RadioItem;

const Send = (props) => {
    const {visible, onClose, onSelect, text, peopleData} = props;
    const [data, setData] = useState([]);

    useEffect(() => {
        axios({
            method: 'post',
            url: '/department/tree',
            data: {},
            withCredentials: false,
        }).then(res => {
            setData(res.data.result)
        })
    }, []);

    const [checked, setChecked] = useState({})

    const checkChange = (val, name) => {
        setChecked({value: val, name});
    };
    const getProps = data => (
        <Accordion>
            { data && data.length > 0 && data.map((item, index) => (
                    <Accordion.Panel className="pd-10" header={item.name} key={index}>
                        {item.subList && item.subList.length > 0 && getProps(item.subList)}
                        {item.userList && item.userList.length > 0 && (
                            <List key={item.name}>
                                {item.userList.map((child) => (
                                    <RadioItem key={child.uid} checked={checked.value === child.uid} onChange={(val) => checkChange(child.uid, child.displayName)}>
                                        {child.displayName}
                                    </RadioItem>
                                ))}
                            </List>
                        )}
                    </Accordion.Panel>
                ))
            }
        </Accordion>
    );

    useEffect(() => {
        visible && setChecked(peopleData)
    }, [visible])

    return (
        <div>
            <Modal
                title={text}
                className="date-modal"
                visible={visible}
                transparent
                onClose={() => onClose(false)}
            >
                <div className="test-box-auto">
                    {getProps(data)}
                </div>

                <div className="modal-form-footer">
                    <Button className="date-button mr-12 bg-gray" inline onClick={() => onClose(false)}>取消</Button>
                    <Button className="date-button" inline type="primary" onClick={() => {onSelect(checked); onClose(false)}}>确认选择</Button>
                </div>
            </Modal>
        </div>
    );
};

export default Send;
