import React from 'react';
import './index.less'
import ChildAddress from '../../../components/AddressList/ChildAddress'

const Index = (props) => {
    const {data, onClick} = props;
    return (
        <div className="address-box">
            {data && data.length > 0 && data.map((item, index) => (
                <div key={index} className="good-item">
                    <div className="address-item address-title" onClick={() => onClick(item.mc)}>
                        {item.mc || ''}
                        <img src="/img/rarrow.png" alt="" className={`icon18 ${item.checked ? 'icon-checked' : 'icon-unchecked'}`}/>
                    </div>
                    { item.checked && item.children.length > 0 && (
                        <div>
                           <ChildAddress data={item.children}/>
                        </div>
                    )}
                </div>
            ))}
        </div>
    );
};

export default Index;
