import React, {useState, useEffect} from 'react';
import Document from 'react-document-title'
import AddressList from '../commponents/Goods';
import axiosRequest from '../../../utils/request';
import Skeleton from '../../../components/Skeleton'

const AddressBook = (props) => {
    const [loading, setLoading] = useState(false);
    const [data, setData] = useState([]);

    const getData = () => {
        setLoading(true);
        axiosRequest({
            method: 'post',
            url: '/idtAppServiceV6/oApp/getDeptTree',
        }).then(res => {
            setLoading(false);
            setData(res)
        });
    };
    useEffect(() => {
        getData()
    }, []);

    // const [userLoading, setUserLoading] = useState(false)
    const treeClick = (DEPTID) => {
        const newData = [...data];
        const index = newData.findIndex(item => item.DEPTID === DEPTID);
        const checked = newData[index].checked ? newData[index] : false;
        newData[index] = {...newData[index], loading: true, children: [], checked: !checked};
        setData(newData);
    };

    return (
        <Document title="参加人数">
            <div>
                <div className='adMainBox'>
                    {loading ? <Skeleton/> : (<AddressList data={data} onClick={treeClick}/>)}
                </div>
            </div>

        </Document>
    );
};

export default AddressBook;

