import React, {useState, useEffect} from 'react';
import Document from 'react-document-title'
import Meet from '../commponents/Meet';
import axiosRequest from '../../../utils/request';
import Skeleton from '../../../components/Skeleton'
import '../index.less'

const AddressBook = (props) => {
    const {attachId} = props.match.params;
    const [loading, setLoading] = useState(false);
    const [data, setData] = useState([]);

    const getData = () => {
        setLoading(true);
        axiosRequest({
            method: 'post',
            url: '/idtAppServiceV6/application/interfaces/getChry.jsp',
            body: {attachId}
        }).then(res => {
            setLoading(false);
            setData(res)
        });
    };
    useEffect(() => {
        getData()
    }, []);

    // const [userLoading, setUserLoading] = useState(false)
    const treeClick = (mc) => {
        const newData = [...data];
        const index = newData.findIndex(item => item.mc === mc);
        const checked = newData[index].checked ? newData[index] : false;
        newData[index] = {...newData[index], checked: !checked};
        setData(newData);
    };
    const getPeople = () => {
        let length = 0;
        data.length > 0 && data.map(item => length += item.children && item.children.length > 0 ? item.children.length : 0);
        return length
    };
    return (
        <Document title="参加人数">
            <div>
                <div className="people-num">参加人数（{getPeople()}）</div>
                <div className='adMainBox meet-box'>
                    {loading ? <Skeleton/> : (<Meet data={data} onClick={treeClick}/>)}
                </div>
            </div>

        </Document>
    );
};

export default AddressBook;

