import React, {useEffect, useState} from 'react';
import Skeleton from '../../components/Skeleton'
import axiosRequest from '../../utils/request';
import AddressCheckbox from '../../components/AddressList/AddressCheckbox';
import {WingBlank, WhiteSpace, Toast} from "antd-mobile";

const SubmitDetail = (props) => {
    const {flowNodeId, uuid, flowTbId} = props.match.params;

    const [data, setData] = useState([]);
    const [loading, setLoading] = useState(false);
    const [disabled, setDisabled] = useState(true);
    useEffect(() => {
        setLoading(true)
        axiosRequest({
            method: 'post',
            url: `/idtAppServiceV6/application/interfaces/flow/getFlowJs.jsp?flowNodeId=${flowNodeId}&flowTbId=${flowTbId}`,
        }).then(res => {
            if (res.tree && res.tree.length === 0) {
                Toast.info('暂无下级办理人员， 请办结事件', 2, () => {
                    props.history.goBack()
                })
            }
            if (res.btn && res.btn.NodeIn === 'true') {
                setLoading(false)
                setData(res)
            }else {
                Toast.info('事件已停止流转', 2, () => {
                    props.history.goBack()
                })
            }

        });

    }, []);

    const [suData, setSuData] = useState([])
    const checkName = (name, checked) => {
        const newData = [...suData];
        const index = newData.findIndex(item => item.XM === name.XM);
        checked ? newData.push({XM: name.XM, XMPY: name.XMPY}) : newData.splice(index, 1);
        newData.length > 0 ? setDisabled(false) : setDisabled(true);
        setSuData(newData)
    }

    const textClick = () => {
        const result = String(data.btn.InUsers) !== '1' ? (suData.length === 1) : true;
        !result && Toast.fail('只可选择一名人员');
        result && axiosRequest({
            method: 'post',
            url: `/idtAppServiceV6/application/interfaces/flow/saveWorkFlowModel.jsp`,
            body: {
                flowNodeId,
                attachId: uuid,
                flowTbId: flowTbId === 'null' ? '' : flowTbId,
                userListMap: JSON.stringify(suData)
            }
        }).then(res => {
            if (res.success === 'success') {
                Toast.success("操作成功", 1, () => {
                    props.history.push('/bord/backlog')
                });

            }
        });

    }
    return (
        <div>
            {loading ? <WingBlank><WhiteSpace/><Skeleton/></WingBlank> : (
                <div>
                    <div className='adMainBox'>
                        <AddressCheckbox data={data.tree} setName={checkName}/>
                    </div>
                    <div className="event-footer">
                        <div className={`event-footer-button ${(disabled) ? 'button-disabled' : '' }`} onClick={textClick}>
                            {suData.length > 0 ?`（${suData.length}）` : null} 确认发送
                        </div>

                    </div>
                </div>
            )}

        </div>
    );
};

export default SubmitDetail;
