import React, {useState, useEffect} from 'react';
import {TabBar} from 'antd-mobile'
import './index.less'
import axiosRequest from '../utils/request';
import queryString from "query-string";

const Footer = (props) => {
    const [current, setCurrent] = useState();
    const [badge, setBadge] = useState();
    const getData = () => {
        axiosRequest({
            method: 'post',
            url: '/idtAppServiceV6/oApp/getWaitDealList',
        }).then(res => {
            setBadge(res.total)
        });
    }
    const tabClick = (key, path) => {
        setCurrent(key);
        props.history.push(path)
    };
    const tabItem = [
        {title: '待办', key: 'backlog', icon: '/img/footer-backlog.png', selectedIcon: '/img/footer-backlog-s.png', badge: badge, onPress: '/bord/backlog'},
        {title: '工作', key: 'work', icon: '/img/footer-work.png', selectedIcon: '/img/footer-work-s.png', badge: '', onPress: '/bord/work'},
        {title: '通讯录', key: 'addressList', icon: '/img/footer-communicate.png', selectedIcon: '/img/footer-communicate-s.png', badge: '', onPress: '/bord/addressList'},
        {title: '通知', key: 'notice', icon: '/img/footer-notice.png', selectedIcon: '/img/footer-notice-s.png', badge: badge, onPress: '/bord/notice'}
    ];
    useEffect(() => {
        new Promise((resolve => {
            const query = queryString.parse(props.location.search);
            const keys = Object.keys(query);
            keys.length > 0 && query.token && localStorage.setItem('token', query.token);
            resolve()
        })).then(() => {
            const keysArray = props.location.pathname.replace(`${props.match.path}/`, '').split("/");
            keysArray.length > 0 && setCurrent(keysArray[0]);
            getData()
        })
    }, []);
    useEffect(() => {
        const url = props.location.pathname;
        url.indexOf('/bord/backlog') > -1 && setCurrent('backlog');
        url.indexOf('/bord/work') > -1 && setCurrent('work');
        url.indexOf('/bord/address') > -1 && setCurrent('addressList');
        url.indexOf('/bord/notice') > -1 && setCurrent('notice');
    }, [props]);

    return (
        <div id="footer" className="footer">
            <TabBar
                unselectedTintColor="#949494"
                tintColor="#2E67EA"
                barTintColor="white"
            >
                {tabItem.map(item => (
                    <TabBar.Item
                        key={item.key}
                        title={item.title}
                        icon={<img alt="" className="footer-tab-icon" src={item.icon}/>}
                        selectedIcon={ <img alt="" className="footer-tab-icon" src={item.selectedIcon}/>}
                        badge={item.badge || null}
                        onPress={() => tabClick(item.key, item.onPress)}
                        selected={current === item.key}
                    />
                ))}
            </TabBar>
        </div>
    );
};

export default Footer;
