import React, {useEffect, useState} from 'react';
import Footer from './Footer'
import {withRouter} from 'react-router-dom'
import './index.less'
import queryString from "query-string";


const CommonLayout = (props) => {
    const resize = (defaultH) => {
        const innerHeight = window.innerHeight;
        const footer = document.getElementById("footer");
        const content = document.getElementById("common-content")
        if (footer) {
            if (defaultH > innerHeight) {
                footer.classList.remove('footer');
                footer.classList.add('footer-static')
            }else {
                footer.classList.add('footer')
                footer.classList.remove('footer-static');
            }
        }
        if (content) {
            if (defaultH > innerHeight) {
                content.classList.remove('common-layout-content');
                content.classList.add('common-layout-content-static');
            }else {
                content.classList.add('common-layout-content');
                content.classList.remove('common-layout-content-static');
            }
        }

        // alert(`defaultH: ${defaultH}   clientHeight: ${scrollHeight}`);
    };

    useEffect(() => {
        const defaultH = window.innerHeight;
        window.addEventListener('resize', () => resize(defaultH));
        return () =>  window.removeEventListener('resize', resize);
    }, []);
    const [bar, setBar] = useState(false);
    useEffect(() => {
        const query = queryString.parse(props.location.search);
        const keys = Object.keys(query);
        keys.length > 0 && query.token && localStorage.setItem('token', query.token);
        keys.length > 0 && query.notabar && setBar(query.notabar === 'true')

    }, []);
    return (
        <div>
            <div id="common-content" className="common-layout-content" >
                <div>
                    {props.children}
                </div>
            </div>
            {!bar &&  <Footer {...props}/>}

        </div>
    );
};

export default withRouter(CommonLayout) ;
