import React, {useEffect} from 'react';
import {withRouter} from 'react-router-dom'
import './index.less'
import queryString from "query-string";

const BlankLayout = (props) => {
    useEffect(() => {
        const query = queryString.parse(props.location.search);
        const keys = Object.keys(query);
        keys.length > 0 && query.token && localStorage.setItem('token', query.token);
    }, [])
    return (
        <div>
            {props.children}
        </div>
    );
};

export default withRouter(BlankLayout);
