import React, {useState} from 'react';
import {Tabs, Icon} from 'antd-mobile'
import './index.less'

const tabs = [
    { title: '未读', sub: 'N' },
    { title: '已读', sub: 'D' }
]

const Index = (props) => {
    const {tabChange} = props;

    const [status, setStatus] = useState(false);

    const topSearch = () => {
        const input = document.getElementsByClassName("top-single-search");
        let inputValue = input[0].value;
        setStatus(inputValue != null && inputValue !== '')
    };
    const enterPress = (e) => {
        const input = document.getElementsByClassName("top-single-search");
        if (e.keyCode === 13) {
            props.onSearch(input[0].value);
        }
    }
    const clear = () => {
        setStatus(false)
        const input = document.getElementsByClassName("top-single-search");
        input[0].value = null;
        input[0].focus();
        props.onSearch('');
    }
    return (
        <div className="pos-line">
            <div className="search-notice-box">
                <Icon type="search" size="xs" className="search-svg"/>
                <input onChange={topSearch} onKeyDown={enterPress} className="top-single-search" placeholder="请输入关键字搜索" />
                {status && (
                    <Icon type="cross-circle-o" color="rgba(35, 35, 35, 0.3)" size="xxs" className="clear-svg"  onClick={clear}/>
                )}
            </div>
            <div className="search-tab">
                <Tabs
                    tabs={tabs}
                    initialPage={'1'}
                    onChange={(tab, index) => tabChange(tab.sub)}
                />
            </div>
        </div>
    );
};

export default Index;
