import React from 'react';
import './index.less'

const Index = (props) => {
    const {data} = props
    return (
        <div className="auto-step">
            <ul className="auto-step-card">
                {
                    data.length > 0 && data.map((item, index) => (
                        <li className="auto-step-item" key={index}>
                            <div className={`auto-step-item-title ${index === data.length -1 ? 'step-current' : 'step-success'}`}>
                                <div className="auto-step-item-title-name">{item.FLOW_ALIASED}</div>
                            </div>
                            <div className={`auto-step-content ${item.s ? '' : 'step-success'}`}>
                                <div className="step-content-wrapper">
                                    <div className="auto-step-content-flow">
                                        <div className="auto-step-content-head">
                                            <img src="/img/test/test-2.png" alt="" className="step-content-head-img"/>
                                            <span>{item.FROMUSER_ALIASED}</span>
                                        </div>
                                      <div className="pos-center">{item.SENDDATE}</div>
                                    </div>
                                    {item.BLYJ && (
                                        <div className="auto-step-content-result">
                                            {item.BLYJ}
                                        </div>
                                    )}
                                </div>
                            </div>

                        </li>
                    ))
                }
            </ul>

        </div>
    );
};

export default Index;
