import React from 'react';
import './index.less'
import Loading from '../Loading'
import {WhiteSpace} from "antd-mobile";

const Index = (props) => {
    const {data, onCLick} = props;
    return (
        <div className="address-box">
            {data && data.length > 0 && data.map((item, index) => item.NAME && (
                <div key={index}>
                    <div onClick={() => onCLick(item.DEPTID)} className="address-item address-title">
                        {item.NAME || ''}
                        <img src="/img/rarrow.png" alt="" className={`icon18 ${item.checked ? 'icon-checked' : 'icon-unchecked'}`}/>
                    </div>
                    { item.checked && item.loading && <div className="address-loading"><WhiteSpace/><Loading/><WhiteSpace/></div>}
                    { !item.loading && item.checked && item.children && (item.children.length > 0 ? (
                        <div className="address-item-box">
                            {item.children.map((child, index2) => (
                                <div className="address-item" key={index2}>
                                    <div>
                                        {/*<img alt="" src="" className=""/>*/}
                                        {child.XM || ''}
                                    </div>
                                    <div className="address-user">
                                        <img alt="" className='smallIco mr-5' src='/img/tel.png' />
                                        <a className="address-phone"
                                           // href={item.YDDH  ? `tel:${item.YDDH}` : null}
                                        >{child.YDDH || '无'}</a>
                                    </div>
                                </div>
                            ))}
                        </div>
                    ): <div className="address-empty">暂无数据</div>)}

                </div>
            ))}
        </div>
    );
};

export default Index;
