import React, {useState, useEffect} from 'react';
import {Button, WhiteSpace, WingBlank} from "antd-mobile";

const TreeData = (props) => {
    const {data, onClick, closeModal, onSubmit, peopleData, peopleSubmit} = props;

    const [treeData, setTreeData] = useState([]);
    useEffect(() => {
        const newData = JSON.parse(JSON.stringify(data));
        newData.map((item, index) => {item.subList = newData.filter(child => item.XH === child.LSID); item.keyIndex = index; return null});
        setTreeData(newData);
    }, [data]);

    const [sGood, setSGood] = useState([]);
    const checkGood = (keyIndex, checked) => {
        const newData = [...sGood];
        const Index = sGood.findIndex(item => item === keyIndex);
        checked ? newData.push(keyIndex) : newData.splice(Index, 1);
        setSGood(newData)
    };
    const submit = () => {
        const subData = data.filter((item, index) => sGood.indexOf(index) > -1);
        onSubmit(sGood);
        findParent(subData);
    };

    const findParent = (treeChild) => {
        const par = data.filter(item => treeChild.findIndex(child => child.LSID === item.XH) > -1);
        const treeChild2 = treeChild.concat(par);
        const par2 = data.filter(item => treeChild2.findIndex(child => child.LSID === item.XH) > -1);
        if (par.length !== par2.length) {
            findParent(treeChild.concat(par2))
        }else {
            peopleSubmit(Array.from(new Set(treeChild2)))
        }
    };
    useEffect(() => {
        setSGood(peopleData)
    }, [peopleData]);
    // console.log(sGood);


    const getProps = (data) => (
        <div className="address-box">
            {data && data.length > 0 && data.map((item, index) => (
                <div key={item.keyIndex}>
                    <div onClick={() => onClick(item.keyIndex)} className="address-item">
                        <div className="address-title">{item.MC || ''}</div>
                        <img src="/img/rarrow.png" alt="" className={`icon18 ${item.checked ? 'icon-checked' : 'icon-unchecked'}`}/>
                    </div>
                    { item.checked && item.subList && (item.subList.length > 0 ? (
                        <div className="address-item-box">
                            {item.subList.map((child, index2) => child.subList.length === 0 ? (
                                <div className="address-item" key={child.keyIndex}>
                                    <div className="xm-box pos-aline">
                                        <input checked={sGood.indexOf(child.keyIndex) > -1} className="auto-checkbox" type="checkbox" onChange={val => checkGood(child.keyIndex, val.target.checked)}/>
                                        {child.XM || ''}
                                    </div>
                                    <div className="address-user">
                                        <img alt="" className='smallIco mr-5' src='/img/tel.png' />
                                        <a className="address-phone">{child.YDDH || '无'}</a>
                                    </div>
                                </div>
                            ) : <div key={child.keyIndex}>{getProps(child.subList)}</div>)}
                        </div>
                    ): (
                        <div className="address-item" key={item.keyIndex}>
                            <div className="xm-box pos-aline">
                                <input checked={sGood.indexOf(item.keyIndex) > -1} className="auto-checkbox" type="checkbox" onChange={val => checkGood(item.keyIndex, val.target.checked)}/>
                                {item.XM || ''}
                            </div>
                            <div className="address-user">
                                <img alt="" className='smallIco mr-5' src='/img/tel.png' />
                                <a className="address-phone">{item.YDDH || '无'}</a>
                            </div>
                        </div>
                    ))}

                </div>
            ))}
        </div>
    );
    return (
        <div>
            <WingBlank>
                <div className="address-box-auto">
                    {getProps(treeData[0] && treeData[0].subList)}
                </div>
                <WhiteSpace/>
                <div className="modal-form-footer">
                    <Button className="date-button mr-12 bg-gray" inline onClick={closeModal}>取消</Button>
                    <Button disabled={sGood.length === 0} className="date-button" inline type="primary" onClick={submit}>确认选择</Button>
                </div>
            </WingBlank>
        </div>
    );
};

export default TreeData;
