import React, {Component} from 'react';
import {WingBlank, WhiteSpace, ActionSheet} from 'antd-mobile'
import './index.less'
import TopTabs from '../../components/TopTabs'
import Basic from './Basic'
import Adjunct from './Adjunct'
import Flow from './Flow';
import Option from './Option';


const isIPhone = new RegExp('\\biPhone\\b|\\biPod\\b', 'i').test(window.navigator.userAgent);
let wrapProps;
if (isIPhone) {
    wrapProps = {
        onTouchStart: e => e.preventDefault(),
    };
}

class Process extends Component {
    constructor() {
        super();
        this.optionBlur = this.optionBlur.bind(this)
        // this.handleScroll = this.handleScroll.bind(this)
        this.state = {
            footButton: '处理'
        }
    };
    componentDidMount() {
        // console.log(document.getElementsByClassName("option-text")[0])
        document.getElementsByClassName("option-text")[0].addEventListener('focus', this.optionBlur, true)
        // window.addEventListener('scroll', this.handleScroll, true);
    }
    optionBlur = () => {
        this.setState({footButton: '确认发送'})
    }

    componentWillUnmount() {
        document.getElementsByClassName("option-text")[0].removeEventListener('focus', this.optionBlur, true)
        // window.removeEventListener('scroll', this.handleScroll, true);
    }
    // handleScroll() {
    //     const basic = document.getElementById("event-basic").offsetTop;
    //     const adjunct = document.getElementById("event-adjunct").offsetTop;
    //     const flow = document.getElementById("event-flow").offsetTop;
    //     const option = document.getElementById("event-option").offsetTop;
    //     const top = document.documentElement.scrollTop;
    //
    //     console.log(top)
    //
    //     // console.log(basic, adjunct, flow, option);
    // };
    tabClick = (name) => {
        // console.log(document.getElementsByClassName("option-text"))
        name === 'option' && document.getElementsByClassName("option-text")[0].focus();
        name === 'option' && this.optionBlur()
        const top = document.getElementById(`event-${name}`).offsetTop;
        document.getElementById("event").scrollTo(0,top - 9)
    };

    showActionSheet = () => {
        const BUTTONS = ['送部门领导审核', '送办公室分管主任审批', '办结', '取消'];
        ActionSheet.showActionSheetWithOptions({
                options: BUTTONS,
                cancelButtonIndex: BUTTONS.length - 1,
                maskClosable: true,
                wrapProps,
            },
            (buttonIndex) => {
                console.log(buttonIndex)
            });
    }

    render() {
        return (
            <div>
                <TopTabs onClick={this.tabClick}/>
                <div id="event">
                    <WingBlank>
                        <WhiteSpace/>
                        <Basic/>
                        <WhiteSpace/>
                        <Adjunct/>
                        <WhiteSpace/>
                        <Flow/>
                        <WhiteSpace/>
                        <Option/>
                    </WingBlank>
                </div>
                <div className="event-footer">
                    <div className="event-footer-button" onClick={this.showActionSheet}>
                        {this.state.footButton}
                    </div>

                </div>

            </div>
        );
    }
}

export default Process;
