import React, {Component} from 'react';
import './index.less'

class CardItem extends Component {
    state = {
        addStatus: false
    }
    componentWillReceiveProps(nextProps, nextContext) {
        if (this.props.addStatus !== nextProps.addStatus) {
            this.setState({ addStatus: nextProps.addStatus });
        }
    };

    contentCLick = () => {
        const {data, addCommon} = this.props;
        const {addStatus} = this.state
        !addStatus && !data.iconAdd && console.log(data.text);
        data.iconAdd && addCommon()
    };
    iconClick = () => {
        const { iconAction} = this.props;
        iconAction()
    }

    render() {
        const {data, type} = this.props;
        const {addStatus} = this.state
        return (
            <div className="card-content" onClick={this.contentCLick}>
                {data.text && (
                    <div className="card-content-box">
                        <div className="card-content-img">
                            {
                                addStatus && !data.iconAdd && (
                                    <img
                                        src={type === 'edit' ? '/img/common-d.png' : '/img/common-a.png'}
                                        className="card-content-img-icon"
                                        alt=""
                                        onClick={this.iconClick}
                                    />
                                )
                            }

                            <img src={data.icon} className="card-content-img-svg" alt="" />
                        </div>
                        <div className="card-content-title">
                            {data.text}
                        </div>
                    </div>
                )}
            </div>
        );
    }
}

export default CardItem;
