import axios from 'axios';
import { stringify } from 'qs';
import { Toast } from 'antd-mobile';

const instance = axios.create();
const token = localStorage.getItem("token");

let defaultHeaders = {
    token,
  };

  const codeMessage = {
    200: '服务器成功返回请求的数据。',
    201: '新建或修改数据成功。',
    202: '一个请求已经进入后台排队（异步任务）。',
    204: '删除数据成功。',
    400: '发出的请求有错误，服务器没有进行新建或修改数据的操作。',
    401: '用户没有权限（用户名或密码错误）。',
    403: '用户得到授权，但是访问是被禁止的。',
    404: '发出的请求针对的是不存在的记录，服务器没有进行操作。',
    406: '请求的格式不可得。',
    410: '请求的资源被永久删除，且不会再得到的。',
    422: '当创建一个对象时，发生一个验证错误。',
    500: '服务器发生错误，请检查服务器。',
    502: '网关错误。',
    503: '服务不可用，服务器暂时过载或维护。',
    504: '网关超时。',
  };

export const createAPI = (baseURL) => {
    return (conf = {}) => {
        let opts = conf.opts || {};
        let body = conf.body || {};
        let urlParams = '';


        let headers = { ...defaultHeaders, ...opts.headers };
        if (conf.queryType === 'query') {
            urlParams = conf.body ? "?" + stringify(conf.body) : '';
        }

        return instance(Object.assign({}, {
            url: conf.url + urlParams,
            baseURL: baseURL,
            method: conf.method,
            data: body,
            headers,
        }, conf.opts))
            .then(function (response) {
                response = response.data;

                if (!response || !response.data) { console.log('response出错, 无返回数据！', response); return false; };
                if (response.data && response.data.errorMessage) {
                    Toast.fail(response.data.errorMessage);
                    return false;
                }
                // 保存到本地
                if (response && response.data && response.data.token) {
                    defaultHeaders = {
                        token: response.data.access_token,
                    }
                    localStorage.setItem("token", response.data.access_token);
                }

                if (response.data) {
                    return response.data;
                } else {
                    return false;
                }
            })
            .catch(error => {
                if (error.response) {
                    const { status, statusText } = error.response;
                    const errortext = codeMessage[status] || statusText;

                    if (status === 401) {
                        // TODO 重新登录
                        // history.push('/user/login');
                        Toast.fail(errortext);
                        return false;
                    } else if (status === 400 || status > 401) {
                        Toast.fail(errortext);
                    }
                }
                return false;
            });
    };
}

export const convertRESTAPI = (url, opts) => {
    if (!opts) return url;

    const pathKeys = Object.keys(opts);

    pathKeys.forEach((key) => {
        const r = new RegExp('(:' + key + '|{' + key + '})', 'g');
        url = url.replace(r, opts[key]);
    });
    return url;
}


