import React from 'react'
import {BrowserRouter as Router, Switch, Route, Redirect} from 'react-router-dom';

import BlankLayout from './layout/BlankLayout';
import CommonLayout from './layout/CommonLayout';
import Backlog from './pages/Backlog/Backlog'
import Work from './pages/Work/Work'
import WorkDetail from './pages/Work/WorkDetail'
import Notice from './pages/Notice/Notice'
import Communicate from './pages/Communicate/Communicate';
import AddressList from './pages/AddressList/AddressList';
import Process from './pages/EventProcessing/Process'
import SubmitDetail from './pages/EventProcessing/SubmitDetail'

import Login from './pages/Login'

import NoFound from './pages/NoFound'



const ReactRouter = () => {
    return (
        <Router>
            <Switch>
                <Route exact path="/" render={() => <Redirect to="/login" />} />
                <Route path="/login" component={Login} />
                <Route path="/bord" render={ () =>
                    <CommonLayout>
                        <Route path="/bord/backlog" component={Backlog} />
                        <Route path="/bord/work" component={Work}/>
                        <Route path="/bord/addressList/:id" component={Communicate}/>
                        <Route path="/bord/addressList" component={AddressList}/>
                        <Route path="/bord/notice" component={Notice}/>
                    </CommonLayout>
                }/>
                <Route path="/blank" component={() =>
                    <BlankLayout>
                        <Route path="/blank/work/:id" component={WorkDetail}/>
                        <Route path="/blank/submit/:id" component={SubmitDetail}/>
                        <Route path="/blank/info/:name/:id" component={Process}/>
                    </BlankLayout>
                }/>
                <Route component={NoFound}/>
            </Switch>
        </Router>
    );
};



export default ReactRouter;

