import React, { useState, useEffect } from 'react';
import {ActivityIndicator, WhiteSpace, WingBlank} from "antd-mobile";
import axiosRequest from '../../utils/request';
import TopSearch from '../../components/TopSearch'
import WorkCard from '../../components/WorkCard';

const Work = (props) => {
    const [loading, setLoading] = useState(false)
    const [addStatus, setAddStatus] = useState(false);
    const [operates, setOperates] = useState([]);
    const [data, setData] = useState([])

    useEffect(() => {
        loadOperates();
    }, []);

    const loadOperates = () => {
        setLoading(true)
        axiosRequest({
            method: 'post',
            url: '/idtAppServiceV6/oApp/getAllOperate',
        }).then(res => {
            setLoading(false);
            const result = res.operate ? res.operate.map(item => ({ icon: '', text: item.NODENAME })) : []
            setOperates(result);
            setData(result)
        });
    }

    const commonEdit = () => {
        setAddStatus(!addStatus);
    };

    const workSearch = (val) => {
        const result = operates.filter(item => item.text && item.text.toLowerCase().indexOf(val.toLowerCase()) > -1);
        if (val !== null && val !== '') {
            setData(result)
        }else {
            setData(operates)
        }
    };

    const itemAdd = (id, arr, arr2) => {
        // const item = arr2.filter(item => item.id === id);
        // arr.splice(arr.length - 1, 0, item[0]);
    };

    // const itemSlice = (id, arr, arr2) => {
    //     // const index = arr.findIndex(item => item.id == id);
    //     // index > -1 && arr.splice(index, 1);
    // };

    const workUrl = (url) => {
        props.history.push(url)
    }

    return (
        <WingBlank>
            <ActivityIndicator
                toast
                text="加载中..."
                animating={loading}
            />
            <WhiteSpace/>
            <TopSearch onSearch={ workSearch }/>
            <WhiteSpace/>
            <WorkCard
                title="工作详情"
                addCommon={ commonEdit }
                addStatus={addStatus}
                data={data}
                workUrl={workUrl}
                iconAction={ itemAdd }
            />
        </WingBlank>
    );
}


export default Work;

