import React, {useEffect, useState} from 'react';
import {ActivityIndicator, WhiteSpace, WingBlank} from 'antd-mobile'
import TodoCard from '../../components/LogCard'
import TopNotice from '../../components/NoticeTab'
import axiosRequest from '../../utils/request';

const Notice = (props) => {
    const [loading, setLoading] = useState(false);
    const [current, setCurrent] = useState(1);
    const [searchWord, setSearchWord] = useState()
    const [data, setData] = useState([]);

    const getData = () => {
        const pageMap ={searchWord, nowPage: current, pageSize: 10};
        console.log(pageMap)
        setLoading(true)
        axiosRequest({
            method: 'post',
            url: '/dgbg/mobileGetWaitDealList.view?userName=2012012099&clientFlag=123456',
        }).then(res => {
            setLoading(false);
            let result = res.rows ?data.concat(res.rows) : data
            setData(result)
            setCurrent(current + 1)
        });
    };

    //下拉加载
    const handleScroll = () => {
        const event = document.getElementById("common-content")
        const top = event.scrollTop;
        const scrollHeight = event.scrollHeight;
        const clientHeight = event.clientHeight;
        if (top + clientHeight === scrollHeight) {
            getData()
        }
    };
    useEffect(() => {
        // window.addEventListener('scroll', handleScroll, true);
        // return () =>  window.removeEventListener('scroll', handleScroll, true);
    }, [data]);

    const checkLog = () => {
        props.history.push(`/blank/info/example/1`)
    };

    //回到顶部
    useEffect(() => {
        const element = document.getElementById('common-content')
        element.scrollTo(0, 0)
    }, []);

    //tab已读未读切换
    const [tab, setTab] = useState('')
    const tabChange = val => {
        setTab(val)
        console.log(val)
    };

    useEffect(() => {
        getData()
    }, [searchWord, tab])
    return (
        <WingBlank>
            <ActivityIndicator
                toast
                text="加载中..."
                animating={loading}
            />
            <WhiteSpace/>
            <TopNotice onSearch={setSearchWord} tabChange={tabChange}/>
            {
                data.map((item, index) => (
                    <div key={index}>
                        <WhiteSpace/>
                        <TodoCard data={item} onClick={checkLog}/>
                    </div>

                ))
            }
        </WingBlank>
    );
};

export default Notice;

