import React, {useState, useEffect} from 'react';
import {Modal} from 'antd-mobile'
import './index.less';
import axiosRequest from '../../utils/request';

const operation = Modal.operation;


const Option = (props) => {
    const onChange = () => {
        const input = document.getElementsByClassName("option-text");
        props.onChange(input[0].value)
    };
    const setValue = (val) => {
        const input = document.getElementsByClassName("option-text");
        input[0].value = val
    };
    useEffect(() => {
        axiosRequest({
            method: 'post',
            url: '/dgbg/mobileGetListOptionKey.view?userName=2012012099&clientFlag=123456',
        }).then(res => {
            console.log(res)
        });
    }, [])
    return (
        <div>
            <div className="option-card">
                <div className="option-title">
                    <div>流转意见：</div>
                    <a
                        className="option-fast"
                        onClick={() => operation([
                            { text: '默认一', onPress: () => setValue('默认一') },
                            { text: '默认二', onPress: () => setValue('默认二') },
                        ])}
                    >
                        常用阅办意见<img alt="" src="/img/option-icon.png" className="option-icon"/>
                    </a>
                </div>
                <textarea className="option-text" onChange={onChange}/>
            </div>
        </div>
    );
};

export default Option;
