import React, {useState, useEffect} from 'react';
import './index.less'
import List from '../../components/List'
import axiosRequest from '../../utils/request';

const Basic = (props) => {
    const [data, setData] = useState([]);
    useEffect(() => {
        const {tableId} = props;
        axiosRequest({
            method: 'post',
            url: `/dgbg/MobileGetFlowsByTabId.view?userName=2012012099&clientFlag=123456&tableId=${tableId}`,
        }).then(res => {
            console.log(res)
            setData([])
        });
    }, [])



    const personImg = data.map((item, index) => (
        <div key={index} className="basic-people-item">
            <img className="work-people-img" alt="" src='/img/test/test.png'/>
            <div>aaa</div>
        </div>
    ))

    const listData = [
        {title: '单位(科室)', content: '文电科'},
        {title: '人数', content: '3'},
        {title: '人员', content: <div className="basic-people-content">{personImg}</div>},
        {title: '目的地', content: '武汉'},
        {title: '事由', content: '考察'},
    ];
    return (
        <div>
            <List
                title={"6.1日,部门考察工作出差申请"}
                listData={listData}
            />
        </div>
    );
};

export default Basic;
