import React, {useEffect, useState} from 'react';
import List from '../../components/List'
import AdjunctList from '../../components/Adjunct'
import axiosRequest from '../../utils/request';

const da222 = Array.from(new Array(7)).map((_val, i) => ({
    id: `name${i}`,
    text: `name${i}`,
}));

const Adjunct = (props) => {
    const [data, setData] = useState([])
    useEffect(() => {
        const {tableId} = props;
        axiosRequest({
            method: 'post',
            url: `/dgbg/MobileGetFlowsByTabId.view?userName=2012012099&clientFlag=123456&tableId=${tableId}`,
        }).then(res => {
            console.log(res, data)
            setData([])
        });
    }, []);
    const listData = [
        {title: '开始时间', content: '文电科'},
        {title: '结束时间', content: '3'},
        {title: '天数', content: ''},
        {title: '乘坐交通工具', content: '武汉'},
        {title: '备注', line: true, content: '函数是也是对象，是一个属性的集合，所以函数下也有属性，也可以自定义属性。当我们创建一个函数时就默认会有一个prototype属性，这个属性是一个对象(属性的集合)。这个东西就是原型---通过调用构造函数而创建的那个对象实例的原型对象。prototype里也有个属性constructor,指向的是函数本身'},
        {title: '附件', line: true, content:
                <div>
                    {da222.map((item, index) => (
                        <AdjunctList key={index} {...item}/>
                    ))}
                </div>
        },
    ]
    return (
        <div>
            <List
                listData={listData}
            />

        </div>
    );
};

export default Adjunct;
