import React, {useState, useEffect} from 'react';
import AddressList from '../../components/AddressList';
import AddressUser from '../../components/AddressList/AddressUser';
import axiosRequest from '../../utils/request';
import {ActivityIndicator} from "antd-mobile";


const Communicate = (props) => {
    const [loading, setLoading] = useState(false);
    const [data, setData] = useState([]);
    const [type, setType] = useState('basic')

    // const {id} = props.match.params;

    // console.log(id, ss);

    const getData = () => {
        setLoading(true);
        axiosRequest({
            method: 'post',
            url: '/idtAppServiceV6/oApp/getSearchAddressBook',
        }).then(res => {
            setLoading(false);
            setData()
        });
    };
    useEffect(() => {
        if (props.location.query && props.location.query.parent) {
            const {parent} = props.location.query;
        }
        // const {parent} = props.location.query;
        console.log(props.location.query)
        getData()
    }, []);


    const getCurrent = () =>{

    }
    return (
        <div>
            <ActivityIndicator
                toast
                text="加载中..."
                animating={loading}
            />
            <div className='breadBox'>
                <span className='currentLink'>科技创新委员会</span>
                <span className='symbol'>&gt;</span>
                <span>组织架构</span>
                <span className='symbol'>&gt;</span>
                <span>办公厅</span>
            </div>
            <div className='adMainBox'>
                <AddressUser data={[{title: '1', children: [{}, {}, {}]}, {title: 2, children: [{}, {}, {}]}, {title: 3, children: [{}, {}, {}]}]}/>
            </div>

        </div>
    );
};

export default Communicate;

