import React, {useState, useEffect} from 'react';
import AddressList from '../../components/AddressList';
import AddressUser from '../../components/AddressList/AddressUser';
import axiosRequest from '../../utils/request';
import {ActivityIndicator} from "antd-mobile";


const AddressBook = (props) => {
    const [loading, setLoading] = useState(false);
    const [data, setData] = useState([]);
    const [type, setType] = useState('basic')

    // const {id} = props.match.params;

    // console.log(id, ss);

    const getData = () => {
        setLoading(true);
        axiosRequest({
            method: 'post',
            url: '/idtAppServiceV6/oApp/getDeptTree',
        }).then(res => {
            setLoading(false);
            setData()
        });
    };
    useEffect(() => {
        getData()
    }, []);

    const treeClick = () => {

    };
    return (
        <div>
            <ActivityIndicator
                toast
                text="加载中..."
                animating={loading}
            />
            <div className='breadBox'>
                <span className='currentLink'>科技创新委员会</span>
                <span className='symbol'>&gt;</span>
                <span>组织架构</span>
                <span className='symbol'>&gt;</span>
                <span>办公厅</span>
            </div>
            <div className='adMainBox'>
                <AddressUser data={data} onCLick={}/>
            </div>

        </div>
    );
};

export default AddressBook;

