import React, {useState, useEffect} from 'react';
import {WhiteSpace, WingBlank, ActivityIndicator} from 'antd-mobile'
import TodoCard from '../../components/LogCard'
import TopSearch from '../../components/TopSearch';
import axiosRequest from '../../utils/request';

const Backlog = (props) => {
    const [current, setCurrent] = useState(1);
    const [searchWord, setSearchWord] = useState()

    const [loading, setLoading] = useState(false);

    const [data, setData] = useState([]);

    const checkLog = (TABLEID) => {
        props.history.push(`/blank/info/example/${TABLEID}`)
    };
    const getData = () => {
        const pageMap ={searchWord, nowPage: current, pageSize: 10};
        console.log(pageMap)
        setLoading(true)
        axiosRequest({
            method: 'post',
            url: '/idtAppServiceV6/getWaitDealList&tableids=1',
        }).then(res => {
            setLoading(false);
            let result = res.rows ? data.concat(res.rows) : data;
            setData(result);
            setCurrent(current + 1);
        });
    };
    useEffect(() => {
        getData()
    }, [searchWord])

    //下拉加载
    const handleScroll = () => {
        const event = document.getElementById("common-content")
        const top = event.scrollTop;
        const scrollHeight = event.scrollHeight;
        const clientHeight = event.clientHeight;
        if (top + clientHeight === scrollHeight) {
            getData()
        }
    };
    useEffect(() => {
        window.addEventListener('scroll', handleScroll, true);
        return () =>  window.removeEventListener('scroll', handleScroll, true);
    }, [data]);

    //回到顶部
    useEffect(() => {
        const element = document.getElementById('common-content')
        element.scrollTo(0, 0)
    }, [])

    return (
        <WingBlank>
            <ActivityIndicator
                toast
                text="加载中..."
                animating={loading}
            />
            <WhiteSpace/>
            <TopSearch onSearch={setSearchWord}/>
            {
                data.map((item, index) => (
                    <div key={index}>
                        <WhiteSpace/>
                        <TodoCard data={item} onClick={() => checkLog(item.TABLEID)}/>
                    </div>

                ))
            }
        </WingBlank>
    );
};

export default Backlog;
