import React, {useState} from 'react';
import {Icon} from 'antd-mobile'
import './index.less'


const Index = (props) => {
    const [status, setStatus] = useState(false);

    const topSearch = () => {
        const input = document.getElementsByClassName("top-single-search");
        props.onSearch(input[0].value);
        let inputValue = input[0].value;
        setStatus(inputValue != null && inputValue !== '')
    };
    const clear = () => {
        setStatus(false)
        const input = document.getElementsByClassName("top-single-search");
        input[0].value = null;
        input[0].focus();
        props.onSearch('');
    }
    return (
        <div className="search-box">
            <Icon type="search" size="xs" className="search-svg"/>
            <input onChange={topSearch} className="top-single-search" placeholder="请输入关键字搜索" />
            {status && (
                <Icon type="cross-circle-o" color="rgba(35, 35, 35, 0.3)" size="xxs" className="clear-svg"  onClick={clear}/>
            )}

        </div>
    );
};

export default Index;
