import React, {PureComponent} from 'react';
import {Icon, Popover} from 'antd-mobile'
import './index.less'

const Item = Popover.Item;

class Index extends PureComponent {
    state={
        visible: false
    };
    visibleChange = (visible) => {
        this.setState({visible})
    };
    onSelect = (val) => {
        console.log(this.props.id);
        this.visibleChange(false)
    }
    render() {
        const {type} = this.props;
        const {visible} = this.state

        return (
            <div className={`adjunct-card ${type ? 'adjunct-word' : 'adjunct-pdf'}`}>
                <div className="adjunct-title">
                    <img alt="" src={type ? '/img/test/test-2.png' : '/img/test/test.png'} className="adjunct-img"/>
                    <div>
                        <p className="adjunct-title-1">武汉考察注意政策</p>
                        <p className="adjunct-title-2">科技创新委员会</p>
                    </div>
                </div>
                <Popover
                    mask
                    visible={visible}
                    overlay={[
                        (<Item key="4" value="scan">下载</Item>),
                    ]}
                    onVisibleChange={this.visibleChange}
                    onSelect={this.onSelect}
                >
                    <Icon type="ellipsis" className="adjunct-icon" size="xxs"/>
                </Popover>


            </div>
        );
    }
}

export default Index;
