import React from 'react'
import {BrowserRouter as Router, Switch, Route, Redirect} from 'react-router-dom';

import BlankLayout from './layout/BlankLayout';
import CommonLayout from './layout/CommonLayout';
import Backlog from './Pages/Backlog/Backlog'
import Work from './Pages/Work/Work'
import Notice from './Pages/Notice/Notice'

import NoFound from './Pages/NoFound'


const ReactRouter = () => {
    return (
        <Router>
            <Switch>
                <Route exact path="/" render={() => <Redirect to="/bord/backlog" />} />
                <Route path="/bord" render={ () =>
                    <CommonLayout>
                        <Route path="/bord/backlog" component={Backlog}/>
                        <Route path="/bord/work" component={Work}/>
                        <Route path="/bord/notice" component={Notice}/>
                    </CommonLayout>
                }/>
                <Route path="/blank" component={() =>
                    <BlankLayout>

                    </BlankLayout>
                }/>
                <Route component={NoFound}/>
            </Switch>
        </Router>
    );
};



export default ReactRouter;

