import React, {useState, useEffect} from 'react';
import {TabBar} from 'antd-mobile'

const Footer = (props) => {
    const [current, setCurrent] = useState();
    useEffect(() => {
        const keysArray = props.location.pathname.replace(`${props.match.path}/`, '').split("/");
        keysArray.length > 0 && setCurrent(keysArray[0])
    }, [props]);

    const tabItem = [
        {title: '待办', key: 'backlog', icon: '', selectedIcon: '', badge: '', onPress: '/bord/backlog'},
        {title: '工作', key: 'work', icon: '', selectedIcon: '', badge: '', onPress: '/bord/work'},
        {title: '通知', key: 'notice', icon: '', selectedIcon: '', badge: '', onPress: '/bord/notice'}
    ];
    const tabClick = (key, path) => {
        setCurrent(key)
        props.history.push(path)
    }

    return (
        <div style={{ position: 'fixed', height: '100%', width: '100%', top: 0 }}>
            <TabBar
                unselectedTintColor="#949494"
                tintColor="#33A3F4"
                barTintColor="white"
            >
                {tabItem.map(item => (
                    <TabBar.Item
                        key={item.key}
                        title={item.title}
                        icon={<div style={{
                            width: '22px',
                            height: '22px',
                            background: `url(https://zos.alipayobjects.com/rmsportal/sifuoDUQdAFKAVcFGROC.svg) center center /  22px 22px no-repeat`
                        }}/>}
                        selectedIcon={<div style={{
                            width: '22px',
                            height: '22px',
                            background: `url(https://zos.alipayobjects.com/rmsportal/sifuoDUQdAFKAVcFGROC.svg) center center /  22px 22px no-repeat`
                        }}/>}
                        badge={item.badge || null}
                        onPress={() => tabClick(item.key, item.onPress)}
                        selected={current === item.key}
                    />
                ))}
            </TabBar>
        </div>
    );
};

export default Footer;
