import React, {useEffect, useState} from 'react';
import { Modal } from "antd-mobile";
import './index.less'
import axiosRequest from "../../../utils/request";

import TreeData from '../../../components/AddressList/TreeData'

const Send = (props) => {
    const {visible, onClose, onSelect, peopleData, UUID} = props;

    const closeModal = () => {
        onClose(false)
    };

    const [data, setData] = useState([]);
    useEffect(() => {
        axiosRequest({
            method: 'post',
            url: '/idtAppServiceV6/exclude/control/getList',
            body: {
                script: 'hysqTreeAll',
                args: JSON.stringify(['47c2c4f9235aa97f01235aa97f7c0000']),
            },
        }).then((res) => {
            res.map(item => {item.ATTACH_ID = UUID; item.checked = false; return null});
            setData(res)
        })
    }, []);

    const onClick = (keyIndex) => {
        const newData = JSON.parse(JSON.stringify(data));
        // const result = newData.findIndex(item => item.XH === XH);
        newData[keyIndex].checked = !newData[keyIndex].checked;
        setData(newData)
    };
    const submitData = val => {
        onSelect(val);
        onClose(false)
    };
    const peopleSubmit = (data) => {
        console.log(data)
        // axiosRequest({
        //     method: 'post',
        //     url: '/idtAppServiceV6/exclude/control/getList',
        //     body: {
        //         script: 'hysqTreeAll',
        //         args: JSON.stringify(['47c2c4f9235aa97f01235aa97f7c0000']),
        //     },
        // }).then((res) => {
        //
        // })
    }

    return (
        <div>
            <Modal
                title="选择参会人员"
                className="date-modal"
                visible={visible}
                transparent
                onClose={() => onClose(false)}
            >
                <TreeData
                    peopleSubmit={peopleSubmit}
                    peopleData={peopleData}
                    data={data}
                    onClick={onClick}
                    closeModal={closeModal}
                    onSubmit={submitData}
                />
            </Modal>
        </div>
    );
};

export default Send;
