import React from 'react';
import { createForm } from 'rc-form';
import {List, Picker, InputItem, Button, Modal, TextareaItem} from "antd-mobile";
import './index.less'

const Send = (props) => {
    const {visible, onClose, addGoods} = props;
    const {getFieldProps, resetFields} = props.form;

    const district = [
        {label: '111', value: '111'}
    ];
    const handleClose = () => {
        resetFields();
        onClose()
    };
    const handleSubmit = () => {
        props.form.validateFields({ force: true }, (error) => {
            if (!error) {
                const values = props.form.getFieldsValue();
                addGoods(values);
                handleClose()
            }
        });

    }

    return (
        <div>
            <Modal
                title="添加物品"
                className="date-modal"
                visible={visible}
                transparent
                onClose={handleClose}
            >
                <form>
                    <List className="goods-form">
                        <InputItem {...getFieldProps('name')}>领取人</InputItem>
                        <Picker data={district} cols={1} {...getFieldProps('ggf1')}>
                            <List.Item arrow="horizontal">品名</List.Item>
                        </Picker>
                        <InputItem {...getFieldProps('amount')} placeholder={`（库存剩余：${0}）`}>申请数量</InputItem>
                        <TextareaItem
                            title="内容"
                            placeholder="请输入内容"
                            {...getFieldProps('_mail_editor_text')}
                            rows={4}
                        />
                    </List>
                </form>

                <div className="modal-form-footer">
                    <Button className="gray-button" inline onClick={handleClose}>关闭</Button>
                    <Button className="date-button" inline type="primary" onClick={handleSubmit}>保存</Button>
                </div>
            </Modal>
        </div>
    );
};

export default createForm()(Send);
