import React, {useEffect, useState} from 'react';
import {WhiteSpace, WingBlank} from 'antd-mobile'
import TodoCard from '../../components/Card/LogCard/WorkCard'
import TopNotice from '../../components/Tabs/NoticeTab/AutoTab'
import axiosRequest from '../../utils/request';
import Skeleton from '../../components/Skeleton'
import Document from 'react-document-title'
import Empty from '../Empty'
import Loading from "../../components/Loading";
import queryString from 'query-string'
import './index.less'

const Notice = (props) => {
    const {type, name} = props.match.params;
    const [start, setStart] = useState(true);
    const [end, setEnd] = useState(true);

    const [current, setCurrent] = useState(0);
    const [searchWord, setSearchWord] = useState();

    const [loading, setLoading] = useState(false);

    const [data, setData] = useState([]);

    const getData = (scroll) => {
        const pageMap ={searchWord, page: current + 1, rows: 10, operateId: tab};
        setLoading(true);
        scroll && current > 0 && window.scrollTo(0, document.body.scrollHeight);
        tab && axiosRequest({
            method: 'post',
            url: '/idtAppServiceV6/oApp/getGridDataList',
            body: pageMap,
        }).then(res => {
            setStart(false);
            setEnd(res.rows && res.rows.length >= 10);
            let result = end && res.rows ? data.concat(res.rows) : data;
            res.rows && res.rows.length >= 10 && setCurrent(current + 1);
            current > 0 && res.rows && res.rows.length === 0 && setCurrent(current - 1);
            setData(result);
            setLoading(false);
        });
    };

    //下拉加载
    const handleScroll = () => {
        let scrollTop = document.documentElement.scrollTop || document.body.scrollTop;
        let clientHeight = document.documentElement.clientHeight || document.body.clientHeight;
        let scrollHeight = document.documentElement.scrollHeight || document.body.scrollHeight;
        // alert(`${scrollTop} ${clientHeight} ${scrollHeight} ${scrollTop + clientHeight >= scrollHeight}`)

        if(scrollHeight > clientHeight && scrollTop + clientHeight >= scrollHeight) {
            getData(true)
        }
    }
    useEffect(() => {
        window.addEventListener('touchend', handleScroll, true);
        return () =>  window.removeEventListener('touchend', handleScroll, true);
    }, [data]);

    const checkLog = (OPERATEID, UUID, FLOWTBID) => {
        const query = queryString.parse(props.location.search);
        Object.keys(query).length > 0
            ? props.history.push(`/blank/${query.type}/${OPERATEID}/${UUID}/${FLOWTBID}`)
            : props.history.push(`/blank/info/${OPERATEID}/${UUID}/${FLOWTBID}`)
    };

    //回到顶部
    useEffect(() => {
        window.scrollTo(0, 0)
    }, []);

    //tab已读未读切换
    const [tab, setTab] = useState();
    const tabChange = val => {
        setCurrent(0);
        setData([]);
        setTab(val);
        setEnd(true)
    };
    const tabSearch = val => {
        setCurrent(0);
        setData([]);
        setSearchWord(val);
        setEnd(true)
    }
    useEffect(() => {
        window.scrollTo(0, 0);
        getData()
    }, [])
    useEffect(() => {
        setStart(true);
        getData(false, [])
    }, [searchWord, tab]);

    const [tabData, setTabData] = useState([]);
    useEffect(() => {
        const menu = JSON.parse(localStorage.getItem("menu"));
        const index = menu.findIndex(item => item.id === type);
        const menuG = menu[index].children.map(item => ({title: item.nodeName, sub: item.id}));
        if (menuG.length > 0) {
            setTab(menuG[0].sub)
        }else {
            setStart(false);
            setLoading(false)
        }
        setTabData(menuG);
    }, []);

    return (
        <Document title="通知">
            <WingBlank>
                <div className="notice-box-content">
                    <WhiteSpace/>
                    <TopNotice tabs={tabData} onSearch={tabSearch} tabChange={tabChange}/>
                    { start ? <div> <WhiteSpace/><Skeleton/><WhiteSpace/><Skeleton/><WhiteSpace/><Skeleton/></div> : ( !start && (
                        data.length > 0 ? data.map((item, index) => (
                            <div key={index}>
                                <WhiteSpace/>
                                <TodoCard name={name} data={item} onClick={() => checkLog(tab, item.UUID, item.FLOWTBID)}/>
                            </div>

                        )) : <Empty/>
                    ))}
                    <WhiteSpace/>
                    {loading && (
                        <div className="pos-line content-loading">
                            <Loading/>
                            <WhiteSpace/>
                            <WhiteSpace/>
                        </div>
                    )}
                    {!loading && !end && data.length > 0 && (
                        <div className="extra-content">
                            <div className="content-end">
                                ——————  我是有底线的  ——————
                            </div>
                        </div>
                    )}
                </div>
                <div className="event-footer">
                    <div className="event-footer-button" onClick={() => props.history.push(`/blank/work-add/${name}`)}>
                        新增
                    </div>
                </div>

            </WingBlank>
        </Document>
    );
};

export default Notice;

