import React, {useEffect, useState} from 'react';
import {WhiteSpace, WingBlank} from 'antd-mobile'
import MailCard from '../../../components/Card/MailCard'
import MailTab from '../../../components/Tabs/BlankTabs/MailTab'
import axiosRequest from '../../../utils/request';
import Skeleton from '../../../components/Skeleton'
import Document from 'react-document-title'
import Empty from '../../Empty'
import Loading from "../../../components/Loading";

import '../index.less'

const Mail = (props) => {
    // const {} = props.match.params;
    const [start, setStart] = useState(true);
    const [end, setEnd] = useState(true);

    const [current, setCurrent] = useState(0);

    const [loading, setLoading] = useState(false);
    // console.log(loading)

    const [data, setData] = useState([]);

    const getData = (scroll) => {
        const pageMap ={nowPage: current + 1, pageSize: 10, folderId: tab, searshKeyWord: '', searshTitle: '',searshSender:'', searshToUser: '',searshAttach: '',searshTime: '',readStatus: false};
        setLoading(true);
        scroll && current > 0 && window.scrollTo(0, document.body.scrollHeight);
        axiosRequest({
            method: 'post',
            url: '/idtAppServiceV6/jspmail/mailGetMailList',
            body: pageMap,
        }).then(res => {
            setStart(false);
            setEnd(res.List && res.List.length >= 10);
            let result = end && res.List ? data.concat(res.List) : data;
            res.List && res.List.length >= 10 && setCurrent(current + 1);
            current > 0 && res.List && res.List.length === 0 && setCurrent(current - 1);
            setData(result);
            setLoading(false);
        });
    };

    //下拉加载
    const handleScroll = () => {
        let scrollTop = document.documentElement.scrollTop || document.body.scrollTop;
        let clientHeight = document.documentElement.clientHeight || document.body.clientHeight;
        let scrollHeight = document.documentElement.scrollHeight || document.body.scrollHeight;
        if(scrollHeight > clientHeight && scrollTop + clientHeight >= scrollHeight) {
            getData(true)
        }
    }
    useEffect(() => {
        window.addEventListener('touchend', handleScroll, true);
        return () =>  window.removeEventListener('touchend', handleScroll, true);
    }, [data]);

    // const checkLog = (OPERATEID, UUID, FLOWTBID) => {
    //     // props.history.push(`/blank/info/${OPERATEID}/${UUID}/${FLOWTBID}`)
    // };

    //tab已读未读切换
    const [tab, setTab] = useState('accept_folder');
    const tabChange = val => {
        setCurrent(0);
        setData([]);
        setTab(val);
        setEnd(true)
    };
    useEffect(() => {
        window.scrollTo(0, 0);
    }, []);
    useEffect(() => {
        if (tab) {
            setStart(true);
            getData(false, [])
        }
    }, [tab]);

    const tabs = [
        { title: '收件箱', key: 'accept_folder' },
        { title: '发件箱', key: 'send_folder' }
    ];

    return (
        <Document title="通知">
            <div>
                <WhiteSpace/>
                <MailTab tabs={tabs} onClick={tabChange}/>
                <WingBlank className="mail-content mb-50">
                    { start ? <div> <WhiteSpace/><Skeleton/><WhiteSpace/><Skeleton/><WhiteSpace/><Skeleton/></div> : ( !start && (
                        data.length > 0 ? data.map((item, index) => (
                            <div key={index}>
                                <WhiteSpace/>
                                <MailCard key={index} data={item} onClick={(uuid) => props.history.push(`/blank/mail-info/${uuid}`)}/>
                            </div>
                        )) : <Empty/>
                    ))}
                </WingBlank>

                <div>
                    {loading && (
                        <div className="pos-line content-loading">
                            <Loading/>
                            <WhiteSpace/>
                            <WhiteSpace/>
                        </div>
                    )}
                    {!loading && !end && data.length > 0 && (
                        <div className="content-end">
                            ——————  我是有底线的  ——————
                        </div>
                    )}
                </div>



                <div className="event-footer">
                    <div className="event-footer-button" onClick={() => props.history.push('/blank/mail-send')}>
                        <img alt="" src="/img/process-edit.png" className="process-edit"/>
                        写信
                    </div>
                </div>
            </div>
        </Document>
    );
};

export default Mail;

