import React, {useEffect, useState} from 'react';
import {WingBlank, List, InputItem, TextareaItem, WhiteSpace} from 'antd-mobile'
import Document from 'react-document-title'
import '../index.less'
import axiosRequest from "../../../utils/request";
import BlobItem from '../../../components/Adjunct/BlobItem'
import Skeleton from '../../../components/Skeleton'

const Send = (props) => {
    const [data, setData] = useState({});
    const [loading, setLoading] = useState(false);
    useEffect(() => {
        setLoading(true);
        const {uuid} = props.match.params;
        axiosRequest({
            method: 'post',
            url: '/idtAppServiceV6/jspmail/mailGetMail',
            body: {uuid},
        }).then(res => {
            setLoading(false);
            setData(res)
        });
    }, []);

    return (
        <Document title="内部邮局">
            <WingBlank>
                <WhiteSpace/>
                {loading ? <Skeleton/> : (
                    <List className="date-info">
                        <InputItem disabled={true} value={data.mailInfo && data.mailInfo.TITLE}>主题</InputItem>
                        <InputItem disabled={true} value={data.mailInfo && JSON.parse(data.mailInfo.RECIPIENT).fzxs_mail_sender_groups}>收件人</InputItem>
                        <TextareaItem
                            disabled={true}
                            title="内容"
                            value={data.clob}
                            rows={4}
                        />
                        <div className="am-textarea-label upload-title">附件：</div>
                        <WingBlank>
                            {data.blobList && data.blobList.length > 0 && data.blobList.map((item, index) => (
                                <BlobItem key={index} data={item}/>
                            ))}
                        </WingBlank>
                        <WhiteSpace/>
                    </List>
                )}

            </WingBlank>
        </Document>
    );
};

export default Send;
